#!/bin/sh


MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_OK=0
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_ERROR=1
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_CODE=${MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_ERROR}
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_ROLLING=0
MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_MSG=""

master_page_sb_reconfig_preparation() {
    debug_print "in function '${FUNCNAME[0]}'"

    ##################################################
    # create file: OriSBGroupInfoESXi
    #     format: /vmfs/volumes/<ds UID>/aaa/aaa.vmx
    ##################################################
    
    # erase
    [ -e "${ORIGIN_SB_GROUP_INFO_ESXI_FILE}" ] && rm -f "${ORIGIN_SB_GROUP_INFO_ESXI_FILE}"
    
    # create
    [ -e "${NEW_SB_GROUP_INFO_ESXI_FILE}" ] && \
        cp -a "${NEW_SB_GROUP_INFO_ESXI_FILE}" "${ORIGIN_SB_GROUP_INFO_ESXI_FILE}" || \
        touch "${ORIGIN_SB_GROUP_INFO_ESXI_FILE}"


    ##################################################
    # create file: OriSBGroupInfoVIX
    #     format: [ha-datacenter/datastore1] aaa/aaa.vmx
    ##################################################
    
    # erase
    [ -e "${ORIGIN_SB_GROUP_INFO_VIX_FILE}" ] && rm -f "${ORIGIN_SB_GROUP_INFO_VIX_FILE}"
    
    # create
    [ -e "${NEW_SB_GROUP_INFO_VIX_FILE}" ] && \
        cp -a "${NEW_SB_GROUP_INFO_VIX_FILE}" "${ORIGIN_SB_GROUP_INFO_VIX_FILE}" || \
        touch "${ORIGIN_SB_GROUP_INFO_VIX_FILE}"
    
    
    ##################################################
    # create file: NewSBGroupInfoESXi
    #     format: /vmfs/volumes/<ds UID>/aaa/aaa.vmx
    ##################################################
    
    # create (overwrite)
    echo "${RT_SB_IMAGE_PATH_ESXI}" | sed 's/,/\n/g' | grep -v "^[:space:]*$" > "${NEW_SB_GROUP_INFO_ESXI_FILE}"
    

    ##################################################
    # create file: NewSBGroupInfoVIX
    #     format: [ha-datacenter/datastore1] aaa/aaa.vmx
    ##################################################
    
    # create (overwrite)
    echo "${RT_SB_IMAGE_PATH_VIX}" | sed 's/,/\n/g' | grep -v "^[:space:]*$" > "${NEW_SB_GROUP_INFO_VIX_FILE}"
    
    
    ##################################################
    # calculate images to be:
    #     Removed
    #     Kept
    #     Added
    # format:
    #     [ha-datacenter/datastore1] aaa/aaa.vmx
    ##################################################
    
    local ori_group_array=(`cat $ORIGIN_SB_GROUP_INFO_ESXI_FILE`)
    local new_group_array=(`cat $NEW_SB_GROUP_INFO_ESXI_FILE`)
    local to_be_removed_array=""; local remove_index=0
    local to_be_kept_array=""; local keep_index=0
    local to_be_added_array=""; local add_index=0
    
    # check origin images are still in new group or not
    local i=1
    local j=1
    for ((i=0; i<${#ori_group_array[@]}; i++))
    do
        local to_be_removed=1
        for ((j=0; j<${#new_group_array[@]}; j++))
        do
            # still in new sandbox group, add to "to_be_kept_array"
            if [ "${ori_group_array[i]}" = "${new_group_array[j]}" ]; then
                to_be_kept_array[$keep_index]="${ori_group_array[i]}"
                keep_index=$(($keep_index+1))
                to_be_removed=0
                break
            fi
        done
        
        # not in new sandbox group, add to "to_be_removed_array"
        if [ "$to_be_removed" = "1" ]; then
            to_be_removed_array[$remove_index]=${ori_group_array[i]}
            remove_index=$(($remove_index+1))
        fi
    done
    
    for ((i=0; i<${#new_group_array[@]}; i++))
    do
        local to_be_added=1
        for ((j=0; j<${#ori_group_array[@]}; j++))
        do
            if [ "${new_group_array[i]}" = "${ori_group_array[j]}" ]; then
                to_be_added=0
                break
            fi
        done
        # not in origin group, add to to_be_added_array
        if [ "$to_be_added" = "1" ]; then
            to_be_added_array[$add_index]=${new_group_array[i]}
            add_index=$(($add_index+1))
        fi
    done

    
    ##################################################
    # create file: NewSBGroupToBeRemoved
    #     format: [ha-datacenter/datastore1] aaa/aaa.vmx
    ##################################################
    
    # create (overwrite)
    echo ${to_be_removed_array[*]} | sed 's/ /\n/g' | grep -v "^[:space:]*$" > $NEW_SB_GROUP_TO_BE_REMOVED_FILE


    ##################################################
    # create file: NewSBGroupToBeKept
    #     format: [ha-datacenter/datastore1] aaa/aaa.vmx
    ##################################################
    
    # create (overwrite)
    echo ${to_be_kept_array[*]} | sed 's/ /\n/g' | grep -v "^[:space:]*$" > $NEW_SB_GROUP_TO_BE_KEPT_FILE
    

    ##################################################
    # create file: NewSBGroupToBeAdded
    #     format: [ha-datacenter/datastore1] aaa/aaa.vmx
    ##################################################
    
    # create (overwrite)
    echo ${to_be_added_array[*]} | sed 's/ /\n/g' | grep -v "^[:space:]*$" > $NEW_SB_GROUP_TO_BE_ADDED_FILE
    
    debug_print "Show sandbox image deferences"
    debug_print "$ORIGIN_SB_GROUP_INFO_ESXI_FILE : `cat $ORIGIN_SB_GROUP_INFO_ESXI_FILE`"
    debug_print "$NEW_SB_GROUP_INFO_ESXI_FILE : `cat $NEW_SB_GROUP_INFO_ESXI_FILE`"
    debug_print "$NEW_SB_GROUP_TO_BE_REMOVED_FILE : `cat $NEW_SB_GROUP_TO_BE_REMOVED_FILE`"
    debug_print "$NEW_SB_GROUP_TO_BE_KEPT_FILE : `cat $NEW_SB_GROUP_TO_BE_KEPT_FILE`"
    debug_print "$NEW_SB_GROUP_TO_BE_ADDED_FILE : `cat $NEW_SB_GROUP_TO_BE_ADDED_FILE`"
}

master_page_sb_image_path_confirm() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    
    ########################################
    # Composing message content
    ########################################
    local content
    
    # no image is selected => remove all sandboxes
    if [ -z "${RT_SB_IMAGE_PATH}" ]; then
        content="${MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_TEXT_REMOVE_ALL_SB}"
 
 
    # re-configure sandboxes result
    else
        content="${MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_TEXT}\n"
        
        local count="`echo "${RT_SB_IMAGE_PATH}" | sed 's/ /\n/g' | grep -v "^[:space:]*$" | wc -l`"
        local clonded_sb_number=`expr "${RT_SB_NUMBER=$conf_number_of_sb}" / "${count}"`

        local sb_image
        for sb_image in $RT_SB_IMAGE_PATH
        do
            content="${content}\n${sb_image}     (${clonded_sb_number} of ${RT_SB_NUMBER:=$conf_number_of_sb} sandboxes)"
        done
    fi
    

    ########################################
    # Sandboxes re-config result confirmation
    ########################################
    tp_yesno \
        "${MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_TITLE}" \
        "${content}" \
        "${MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_LABEL_OK}" \
        "${MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_LABEL_CANCEL}"

    debug_print "TP_YESNO_RESULT_CODE: ${TP_YESNO_RESULT_CODE}"
    if [ "${TP_YESNO_RESULT_SELECT}" != "${TP_YESNO_RESULT_YES}" ]; then		
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_CODE="${MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_OK}"
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_ROLLING=-1
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_MSG=""
        return
    fi  

    
    ########################################
    # Generate related files
    ########################################
    master_page_sb_reconfig_preparation

    
    ########################################
    # notify eemaild that it's going to reconfig sandboxes
    ########################################
    utility_save_reconfig_sb_conf 1
    if [ "${?}" -ne 0 ]; then
        debug_print "fail to modify 'configuration.extract_email.reconfigure_sanbox' to 0"
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_ROLLING=0
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_CODE=${MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_ERROR}
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_MSG="${MASTER_PAGE_SB_DEPLOY_DONE_ERROR_SAVE_CONFIGURATION}"
        return
    fi
    
    
    ########################################
    # update sandbox number because user might change sandbox number 
    # when all sandboxes are removed
    ########################################
	utility_save_sb_num_conf "${RT_SB_NUMBER}"
    if [ "${?}" -ne 0 ]; then
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_ROLLING=0
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_CODE="${MASTER_PAGE_SB_DEPLOY_DONE_RESULT_ERROR}"
        MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_MSG="${UTILITY_SAVE_SB_NUM_CONF_RESULT_MSG}"
        return
    fi
    
    
    MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_OK
    MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_ROLLING=1
    MASTER_PAGE_SB_IMAGE_PATH_CONFIRM_RESULT_MSG=""
}
